﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Project_new.Models;

namespace Project_new.Controllers.QuanLy
{
    public class QuanLyChiTietDonHangController : Controller
    {
        private Project_newEntities db = new Project_newEntities();

        // GET: QuanLyChiTietDonHang
        public ActionResult Index(string ctdh = "")
        {
            if (ctdh != "")
            {
                var donDatHangChiTiet = db.DonDatHangChiTiets.Include(d => d.DonDatHang).Include(d => d.SanPham).Where(a => a.DonDatHang.MaDDH.ToUpper().Contains(ctdh.ToUpper()));
                return View(donDatHangChiTiet.ToList());
            }

            var donDatHangChiTiets = db.DonDatHangChiTiets.Include(d => d.DonDatHang).Include(d => d.SanPham);
            return View(donDatHangChiTiets.ToList());
        }

        // GET: QuanLyChiTietDonHang/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            DonDatHangChiTiet donDatHangChiTiet = db.DonDatHangChiTiets.Find(id);
            if (donDatHangChiTiet == null)
            {
                return HttpNotFound();
            }
            return View(donDatHangChiTiet);
        }

        // GET: QuanLyChiTietDonHang/Create
        public ActionResult Create()
        {
            ViewBag.MaDDH = new SelectList(db.DonDatHangs, "MaDDH", "SdtKH");
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP");
            return View();
        }

        // POST: QuanLyChiTietDonHang/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "MaDDHCT,MaDDH,MaSP,SoLuongDDHCT,ThanhTienDDHCT")] DonDatHangChiTiet donDatHangChiTiet)
        {
            if (ModelState.IsValid)
            {
                db.DonDatHangChiTiets.Add(donDatHangChiTiet);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.MaDDH = new SelectList(db.DonDatHangs, "MaDDH", "SdtKH", donDatHangChiTiet.MaDDH);
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP", donDatHangChiTiet.MaSP);
            return View(donDatHangChiTiet);
        }

        // GET: QuanLyChiTietDonHang/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            DonDatHangChiTiet donDatHangChiTiet = db.DonDatHangChiTiets.Find(id);
            if (donDatHangChiTiet == null)
            {
                return HttpNotFound();
            }
            ViewBag.MaDDH = new SelectList(db.DonDatHangs, "MaDDH", "SdtKH", donDatHangChiTiet.MaDDH);
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP", donDatHangChiTiet.MaSP);
            return View(donDatHangChiTiet);
        }

        // POST: QuanLyChiTietDonHang/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "MaDDHCT,MaDDH,MaSP,SoLuongDDHCT,ThanhTienDDHCT")] DonDatHangChiTiet donDatHangChiTiet)
        {
            if (ModelState.IsValid)
            {
                db.Entry(donDatHangChiTiet).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.MaDDH = new SelectList(db.DonDatHangs, "MaDDH", "SdtKH", donDatHangChiTiet.MaDDH);
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP", donDatHangChiTiet.MaSP);
            return View(donDatHangChiTiet);
        }

        // GET: QuanLyChiTietDonHang/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            DonDatHangChiTiet donDatHangChiTiet = db.DonDatHangChiTiets.Find(id);
            if (donDatHangChiTiet == null)
            {
                return HttpNotFound();
            }
            return View(donDatHangChiTiet);
        }

        // POST: QuanLyChiTietDonHang/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            DonDatHangChiTiet donDatHangChiTiet = db.DonDatHangChiTiets.Find(id);
            db.DonDatHangChiTiets.Remove(donDatHangChiTiet);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
