﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Project_new.Models;

namespace Project_new.Controllers.QuanLy
{
    public class QuanLyCongThucController : Controller
    {
        private Project_newEntities db = new Project_newEntities();

        // GET: QuanLyCongThuc
        public ActionResult Index(string TimKiemQLCT = "")
        {
            var congThucs = db.CongThucs.Include(c => c.NguyenLieu).Include(c => c.SanPham);

            if (!string.IsNullOrEmpty(TimKiemQLCT))
            {
                TimKiemQLCT = TimKiemQLCT.ToUpper();
                congThucs = congThucs.Where(s =>
                    s.GhiChu.ToUpper().Contains(TimKiemQLCT) ||
                    s.NguyenLieu.TenNL.ToUpper().Contains(TimKiemQLCT) ||
                    s.SanPham.TenSP.ToUpper().Contains(TimKiemQLCT)
                );
            }

            return View(congThucs.ToList());
        }

        // GET: QuanLyCongThuc/Details
        public ActionResult Details(string maSP, int maNL)
        {
            if (maSP == null || maNL == null)
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);

            CongThuc congThuc = db.CongThucs.FirstOrDefault(c => c.MaSP == maSP && c.MaNL == maNL);
            if (congThuc == null)
                return HttpNotFound();

            return View(congThuc);
        }

        // GET: QuanLyCongThuc/Edit
        public ActionResult Edit(string maSP, int maNL)
        {
            if (maSP == null || maNL == null)
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);

            CongThuc congThuc = db.CongThucs.FirstOrDefault(c => c.MaSP == maSP && c.MaNL == maNL);
            if (congThuc == null)
                return HttpNotFound();

            ViewBag.MaNL = new SelectList(db.NguyenLieux, "MaNL", "TenNL", congThuc.MaNL);
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP", congThuc.MaSP);
            return View(congThuc);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "MaSP,MaNL,SoLuongCanDung,GhiChu")] CongThuc congThuc)
        {
            if (ModelState.IsValid)
            {
                db.Entry(congThuc).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.MaNL = new SelectList(db.NguyenLieux, "MaNL", "TenNL", congThuc.MaNL);
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP", congThuc.MaSP);
            return View(congThuc);
        }

        // GET: QuanLyCongThuc/Delete
        public ActionResult Delete(string maSP, int maNL)
        {
            if (maSP == null || maNL == null)
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);

            CongThuc congThuc = db.CongThucs.FirstOrDefault(c => c.MaSP == maSP && c.MaNL == maNL);
            if (congThuc == null)
                return HttpNotFound();

            return View(congThuc);
        }

        // POST: QuanLyCongThuc/Delete
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(string maSP, int maNL)
        {
            CongThuc congThuc = db.CongThucs.FirstOrDefault(c => c.MaSP == maSP && c.MaNL == maNL);
            db.CongThucs.Remove(congThuc);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }

        public ActionResult Create()
        {
            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP");
            ViewBag.MaNL = new SelectList(db.NguyenLieux, "MaNL", "TenNL");
            return View();
        }
        // POST: QuanLyCongThuc/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "MaSP,MaNL,SoLuongCanDung,GhiChu")] CongThuc congThuc)
        {
            if (ModelState.IsValid)
            {
                // Kiểm tra nếu công thức với cùng MaSP và MaNL đã tồn tại
                var existing = db.CongThucs.FirstOrDefault(c => c.MaSP == congThuc.MaSP && c.MaNL == congThuc.MaNL);
                if (existing != null)
                {
                    ModelState.AddModelError("", "Công thức với sản phẩm và nguyên liệu này đã tồn tại.");
                }
                else
                {
                    db.CongThucs.Add(congThuc);
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }
            }

            ViewBag.MaSP = new SelectList(db.SanPhams, "MaSP", "TenSP", congThuc.MaSP);
            ViewBag.MaNL = new SelectList(db.NguyenLieux, "MaNL", "TenNL", congThuc.MaNL);
            return View(congThuc);
        }

    }

}
