﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Data.Entity.Migrations;
using System.IO;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Project_new.Models;

namespace Project_new.Controllers.QuanLy
{
    public class QuanLyDanhMucController : Controller
    {
        private Project_newEntities db = new Project_newEntities();

        // GET: QuanLyDanhMuc
        public ActionResult Index(string error, string tenDM = "")
        {
            if (tenDM != "")
            {
                var danhMuc = db.DanhMucs.Where(a => a.TenDM.ToUpper().Contains(tenDM.ToUpper()));
                return View(danhMuc.ToList());
            }


            ViewBag.CateError = error;
            var modelCate = db.DanhMucs.ToList();
            return View(modelCate);
        }

        // GET: QuanLyDanhMuc/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            DanhMuc danhMuc = db.DanhMucs.Find(id);
            if (danhMuc == null)
            {
                return HttpNotFound();
            }
            return View(danhMuc);
        }

        // GET: 
        public ActionResult Create()
        {
            return View();
        }

        // POST: QuanLyDanh
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "MaDM,TenDM,AnhDM")] DanhMuc danhMuc, HttpPostedFileBase file)
        {

            if (file != null)
            {
                if (file.ContentLength > 0)
                {
                    try
                    {
                        string nameFile = Path.GetFileName(file.FileName);
                        file.SaveAs(Path.Combine(Server.MapPath("/Image/"), nameFile));
                        danhMuc.AnhDM = "/Image/" + nameFile;
                    }
                    catch (Exception)
                    {
                        ViewBag.CreateCategory = "Không thể chọn ảnh.";
                    }
                }
                try
                {
                    if (db.DanhMucs.SingleOrDefault(a => a.TenDM.Equals(danhMuc.TenDM)) == null)
                    {
                        db.DanhMucs.AddOrUpdate(danhMuc);
                        db.SaveChanges();
                        ViewBag.Create = "Thêm danh mục thành công.";
                    }
                    else
                    {
                        ViewBag.Create = "Tên danh mục đã tồn tại.";
                    }
                }
                catch (Exception)
                {
                    ViewBag.Create = "Không thể thêm danh mục.";
                }
            }
            else
            {
                ViewBag.HinhAnh = "Vui lòng chọn hình ảnh.";
            }
            return View();
        }

        // GET: QuanLyDanhMuc_
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            DanhMuc danhMuc = db.DanhMucs.Find(id);
            if (danhMuc == null)
            {
                return HttpNotFound();
            }
            return View(danhMuc);
        }

        // POST: QuanLyDanhMuc_
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "MaDM,TenDM,AnhDM")] DanhMuc danhMuc, HttpPostedFileBase file)
        {
            if (file != null)
            {
                if (file.ContentLength > 0)
                {
                    try
                    {
                        string nameFile = Path.GetFileName(file.FileName);
                        file.SaveAs(Path.Combine(Server.MapPath("/Image/"), nameFile));
                        danhMuc.AnhDM = "/Image/" + nameFile;
                    }
                    catch (Exception)
                    {
                        ViewBag.Create = "Không thể chọn ảnh.";
                    }
                }
                try
                {
                    if (db.DanhMucs.SingleOrDefault(a => a.TenDM.Equals(danhMuc.TenDM)) == null)
                    {
                        db.DanhMucs.AddOrUpdate(danhMuc);
                        db.SaveChanges();
                        ViewBag.Create = "Cập nhật danh mục thành công.";
                    }
                    else
                    {
                        ViewBag.Create = "Tên danh mục đã tồn tại.";
                    }
                }
                catch (Exception)
                {
                    ViewBag.Create = "Không thể cập nhật danh mục.";
                }
            }
            else
            {
                ViewBag.HinhAnh = "Vui lòng chọn hình ảnh.";
            }
            return View();
        }


        // GET: QuanLyDanhMuc
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            DanhMuc danhMuc = db.DanhMucs.Find(id);
            if (danhMuc == null)
            {
                return HttpNotFound();
            }
            return View(danhMuc);
        }

        // POST: QuanLyDanhMuc_
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            var model = db.DanhMucs.SingleOrDefault(a => a.MaDM.Equals(id));
            try
            {
                if (model != null)
                {
                    db.DanhMucs.Remove(model);
                    db.SaveChanges();
                    return RedirectToAction("Index", "QuanLyDanhMuc", new { error = "Xoá danh mục thành công." });
                }
                else
                {
                    return RedirectToAction("Index", "QuanLyDanhMuc", new { error = "Danh mục không tồn tại." });
                }
            }
            catch (Exception)
            {
                return RedirectToAction("Index", "QuanLyDanhMuc", new { error = "Không thể xoá danh mục." });
            }
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
