﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Project_new.Models;

namespace Project_new.Controllers.QuanLy
{
    public class QuanLyNguyenLieuController : Controller
    {
        private Project_newEntities db = new Project_newEntities();

        // GET: QuanLyNguyenLieu
        public ActionResult Index(string TimKiemNL = "")
        {
            var nguyenLieux = db.NguyenLieux.ToList();

            if (!string.IsNullOrEmpty(TimKiemNL))
            {
                TimKiemNL = TimKiemNL.ToUpper();

                nguyenLieux = nguyenLieux.Where(s =>
                    s.MaNL.ToString().ToUpper().Contains(TimKiemNL) ||
                    s.TenNL.ToUpper().Contains(TimKiemNL) ||
                    s.DonViTinh.ToUpper().Contains(TimKiemNL) ||
                    s.SoLuongTon.ToString().ToUpper().Contains(TimKiemNL) ||
                    s.DonGia.ToString().ToUpper().Contains(TimKiemNL) ||
                    s.HanSuDung.ToString().ToUpper().Contains(TimKiemNL) ||
                    s.NhaCungCap.ToUpper().Contains(TimKiemNL) ||
                    s.MoTa.ToUpper().Contains(TimKiemNL)
                ).ToList(); // Quan trọng: nhớ gọi .ToList()
            }

            return View(nguyenLieux);

        }

        // GET: QuanLyNguyenLieu/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            NguyenLieu nguyenLieu = db.NguyenLieux.Find(id);
            if (nguyenLieu == null)
            {
                return HttpNotFound();
            }
            return View(nguyenLieu);
        }

        // GET: QuanLyNguyenLieu/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: QuanLyNguyenLieu/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "MaNL,TenNL,DonViTinh,SoLuongTon,DonGia,HanSuDung,NhaCungCap,MoTa")] NguyenLieu nguyenLieu)
        {
            if (ModelState.IsValid)
            {
                db.NguyenLieux.Add(nguyenLieu);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(nguyenLieu);
        }

        // GET: QuanLyNguyenLieu/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            NguyenLieu nguyenLieu = db.NguyenLieux.Find(id);
            if (nguyenLieu == null)
            {
                return HttpNotFound();
            }
            return View(nguyenLieu);
        }

        // POST: QuanLyNguyenLieu/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "MaNL,TenNL,DonViTinh,SoLuongTon,DonGia,HanSuDung,NhaCungCap,MoTa")] NguyenLieu nguyenLieu)
        {
            if (ModelState.IsValid)
            {
                db.Entry(nguyenLieu).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(nguyenLieu);
        }

        // GET: QuanLyNguyenLieu/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            NguyenLieu nguyenLieu = db.NguyenLieux.Find(id);
            if (nguyenLieu == null)
            {
                return HttpNotFound();
            }
            return View(nguyenLieu);
        }

        // POST: QuanLyNguyenLieu/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            NguyenLieu nguyenLieu = db.NguyenLieux.Find(id);
            db.NguyenLieux.Remove(nguyenLieu);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
